unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Bevel1: TBevel;
    Label3: TLabel;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

type
     TSimpleShape =(Rectangle, Circle, Quadrate, Point);

type
  TSimpleFigure = record
     Key   : TSimpleShape;
     X, Y  : integer;
     case TSimpleShape of
     Rectangle  : (Heigth, Width : integer);
     Circle, Quadrate : (Size : integer);
     Point :();
end;

const
  Figure1 : TSimpleFigure = (Key : Rectangle;
                             X : 10; Y : 20;
                             Heigth : 30; Width : 40);
  Figure2 : TSimpleFigure = (Key : Circle;
                             X : 10; Y : 20;
                             Size : 10);
  Figure3 : TSimpleFigure = (Key : Quadrate;
                             X : 10; Y : 20;
                             Size : 10);
  Figure4 : TSimpleFigure = (Key : Point;
                             X : 10; Y : 20;);

// -----------------------------------------------------------
function ViewFigure (RqFigure : TSimpleFigure) : string;
var WStr : string;
begin
  WStr := '';
  case RqFigure.Key of
     Rectangle : begin
         WStr := 'Rectangle :';
         WStr := WStr + ' X = ' + IntToStr(RqFigure.X) + ';';
         WStr := WStr + ' Y = ' + IntToStr(RqFigure.Y) + ';';
         WStr := WStr + ' Heigth = ' + IntToStr(RqFigure.Heigth) + ';';
         WStr := WStr + ' Width = ' + IntToStr(RqFigure.Width) + ';';
         WStr := WStr + ' // SizeOF = ' + IntToStr(SizeOF(RqFigure));
         Result := WStr;
     end;
     Circle : begin
         WStr := 'Circle :';
         WStr := WStr + ' X = ' + IntToStr(RqFigure.X) + ';';
         WStr := WStr + ' Y = ' + IntToStr(RqFigure.Y) + ';';
         WStr := WStr + ' Size = ' + IntToStr(RqFigure.Size) + ';';
         WStr := WStr + ' // SizeOF = ' + IntToStr(SizeOF(RqFigure));
         Result := WStr;
     end;
     Quadrate : begin
         WStr := 'Quadrate :';
         WStr := WStr + ' X = ' + IntToStr(RqFigure.X) + ';';
         WStr := WStr + ' Y = ' + IntToStr(RqFigure.Y) + ';';
         WStr := WStr + ' Size = ' + IntToStr(RqFigure.Size) + ';';
         WStr := WStr + ' // SizeOF = ' + IntToStr(SizeOF(RqFigure));
         Result := WStr;
     end;
     Point : begin
         WStr := 'Point :';
         WStr := WStr + ' X = ' + IntToStr(RqFigure.X) + ';';
         WStr := WStr + ' Y = ' + IntToStr(RqFigure.Y) + ';';
         WStr := WStr + ' // SizeOF = ' + IntToStr(SizeOF(RqFigure));
         Result := WStr;
     end;
     else  Result := ' Shape';
  end;
end;

// -----------------------------------------------------------
//  ViewFigure
procedure TForm1.Button1Click(Sender: TObject);
begin
  ListBox1.Clear;
  ListBox1.Items.Add(ViewFigure (Figure1));
  ListBox1.Items.Add(ViewFigure (Figure2));
  ListBox1.Items.Add(ViewFigure (Figure3));
  ListBox1.Items.Add(ViewFigure (Figure4));
end;
// -----------------------------------------------------------

end.
